/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.movement;

import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.network.SendPacketEvent;
import Krasnodar.rockstarnew.systems.event.impl.player.ClientPlayerTickEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.settings.BooleanSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SliderSetting;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2596;

@ModuleInfo(name="Fake Lag", category=ModuleCategory.MOVEMENT, desc="\u0417\u0430\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043f\u0430\u043a\u0435\u0442\u044b \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u044d\u0444\u0444\u0435\u043a\u0442\u0430 \u043b\u0430\u0433\u0430")
public class FakeLag
extends BaseModule {
    private final SliderSetting delay = new SliderSetting(this, "\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430").min(100.0f).max(3000.0f).step(50.0f).currentValue(400.0f);
    private final SliderSetting maxPackets = new SliderSetting(this, "\u041c\u0430\u043a\u0441 \u043f\u0430\u043a\u0435\u0442\u043e\u0432/\u0442\u0438\u043a").min(1.0f).max(20.0f).step(1.0f).currentValue(3.0f);
    private final BooleanSetting pulseMode = new BooleanSetting(this, "Pulse \u0440\u0435\u0436\u0438\u043c");
    private final SliderSetting pulseDuration = new SliderSetting(this, "\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043f\u0443\u043b\u044c\u0441\u0430").min(100.0f).max(3000.0f).step(100.0f).currentValue(500.0f);
    private final SliderSetting pulseCooldown = new SliderSetting(this, "\u041a\u0443\u043b\u0434\u0430\u0443\u043d \u043f\u0443\u043b\u044c\u0441\u0430").min(0.0f).max(5000.0f).step(100.0f).currentValue(1500.0f);
    private final SliderSetting maxPulsePackets = new SliderSetting(this, "\u041c\u0430\u043a\u0441 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u0437\u0430 \u043f\u0443\u043b\u044c\u0441").min(10.0f).max(200.0f).step(10.0f).currentValue(80.0f);
    private final BooleanSetting playerRange = new BooleanSetting(this, "\u0422\u043e\u043b\u044c\u043a\u043e \u0440\u044f\u0434\u043e\u043c \u0441 \u0438\u0433\u0440\u043e\u043a\u0430\u043c\u0438");
    private final SliderSetting activateRadius = new SliderSetting(this, "\u0420\u0430\u0434\u0438\u0443\u0441 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438").min(5.0f).max(30.0f).step(1.0f).currentValue(20.0f);
    private final BooleanSetting autoFlushOnStop = new BooleanSetting(this, "\u0421\u0431\u0440\u043e\u0441 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435");
    private final BooleanSetting flushOnDisable = new BooleanSetting(this, "\u0421\u0431\u0440\u043e\u0441 \u043f\u0440\u0438 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438");
    private final ConcurrentLinkedQueue<TimedPacket> packets = new ConcurrentLinkedQueue();
    private boolean pulsing = false;
    private long pulseStartTime = 0L;
    private long lastPulseEndTime = 0L;
    private final EventListener<SendPacketEvent> onPacket = event -> {
        if (FakeLag.mc.field_1724 == null || FakeLag.mc.field_1687 == null) {
            return;
        }
        if (!this.isLaggingAllowed()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.pulseMode.isEnabled()) {
            if (!this.pulsing) {
                if (!this.canStartPulse(now)) {
                    return;
                }
                this.pulsing = true;
                this.pulseStartTime = now;
            }
            this.packets.add(new TimedPacket(event.getPacket(), now));
            event.cancel();
        } else {
            this.packets.add(new TimedPacket(event.getPacket(), now));
            event.cancel();
        }
    };
    private final EventListener<ClientPlayerTickEvent> onTick = event -> {
        if (FakeLag.mc.field_1724 == null || FakeLag.mc.field_1724.field_3944 == null) {
            return;
        }
        if (!this.isLaggingAllowed()) {
            this.flushAllPackets();
            return;
        }
        long now = System.currentTimeMillis();
        long delayMs = (long)this.delay.getCurrentValue();
        if (this.pulseMode.isEnabled()) {
            if (this.pulsing) {
                boolean tooManyPackets;
                boolean tooLong = this.isPulseExpired(now);
                boolean bl = tooManyPackets = this.packets.size() >= (int)this.maxPulsePackets.getCurrentValue();
                if (tooLong || tooManyPackets) {
                    this.flushAllPackets();
                    this.pulsing = false;
                    this.lastPulseEndTime = now;
                }
            }
        } else {
            int maxPerTick = (int)this.maxPackets.getCurrentValue();
            int sent = 0;
            for (TimedPacket timedPacket : this.packets) {
                if (sent >= maxPerTick) break;
                if (now - timedPacket.time < delayMs) continue;
                FakeLag.mc.field_1724.field_3944.method_48296().method_10743(timedPacket.packet);
                this.packets.remove(timedPacket);
                ++sent;
            }
            if (this.autoFlushOnStop.isEnabled() && this.isPlayerStopped() && !this.packets.isEmpty()) {
                this.flushAllPackets();
            }
        }
    };

    @Override
    public void onEnable() {
        super.onEnable();
        this.packets.clear();
        this.pulsing = false;
        this.pulseStartTime = 0L;
        this.lastPulseEndTime = 0L;
    }

    @Override
    public void onDisable() {
        super.onDisable();
        if (this.flushOnDisable.isEnabled()) {
            this.flushAllPackets();
        } else {
            this.packets.clear();
        }
        this.pulsing = false;
    }

    private void flushAllPackets() {
        if (FakeLag.mc.field_1724 == null || FakeLag.mc.field_1724.field_3944 == null) {
            this.packets.clear();
            return;
        }
        for (TimedPacket p : this.packets) {
            FakeLag.mc.field_1724.field_3944.method_48296().method_10743(p.packet);
        }
        this.packets.clear();
    }

    private boolean hasNearbyPlayer() {
        if (FakeLag.mc.field_1687 == null || FakeLag.mc.field_1724 == null) {
            return false;
        }
        double radius = this.activateRadius.getCurrentValue();
        double radiusSq = radius * radius;
        for (class_1657 player : FakeLag.mc.field_1687.method_18456()) {
            double distSq;
            if (player == FakeLag.mc.field_1724 || player.method_29504() || player.method_31481() || !((distSq = player.method_5858((class_1297)FakeLag.mc.field_1724)) <= radiusSq)) continue;
            return true;
        }
        return false;
    }

    private boolean isPlayerStopped() {
        if (FakeLag.mc.field_1724 == null) {
            return false;
        }
        class_243 vel = FakeLag.mc.field_1724.method_18798();
        double speedSq = vel.field_1352 * vel.field_1352 + vel.field_1350 * vel.field_1350;
        return speedSq < 1.0E-4;
    }

    private boolean canStartPulse(long now) {
        long cooldown = (long)this.pulseCooldown.getCurrentValue();
        return !this.pulsing && now - this.lastPulseEndTime >= cooldown;
    }

    private boolean isPulseExpired(long now) {
        long duration = (long)this.pulseDuration.getCurrentValue();
        return this.pulsing && now - this.pulseStartTime >= duration;
    }

    private boolean isLaggingAllowed() {
        return !this.playerRange.isEnabled() || this.hasNearbyPlayer();
    }

    private static class TimedPacket {
        private final class_2596<?> packet;
        private final long time;

        public TimedPacket(class_2596<?> packet, long time) {
            this.packet = packet;
            this.time = time;
        }
    }
}

